unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Printers;

type

//=============================================================================
   Noeud=
        class
           private
              op:char;
              valeur:integer;
              FilsGauche,FilsDroit:Noeud;
           public
              constructor create ;
              destructor destroy ;
        end; { Noeud }

    Arbre =
        class
           private
              tete:noeud ;
           public
              constructor create ;
              destructor  destroy ;override ;
              procedure   Remplit(courant:noeud; s:string; signe1,signe2:char) ;
              function    evalue(n:noeud):integer;
              function    compter_terminaux(courant : noeud) : integer ;
              function    compter_niveaux(courant : noeud) : integer ;
              procedure   dessine(courant : noeud ;limg,niveau,old_x,old_y : integer; cnv:TCanvas;
                                  offx,offy,largeur,hauteur:integer; coeffx,coeffy:real) ;
        end ; {arbre}
//=============================================================================

  TForm1 = class(TForm)
    Edit1: TEdit;
    Button1: TButton;
    Label1: TLabel;
    Image1: TImage;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Image2: TImage;
    SaveDialog1: TSaveDialog;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
  private
    { Dclarations prives }
  public
    { Dclarations publiques }
  end;

var
  Form1: TForm1;
  UnArbre:Arbre;
  numero:integer;  //juste pour le nom du fichier  enregistrer

implementation

{$R *.DFM}

constructor noeud.create ;
begin
     FilsGauche:=nil;
     FilsDroit:=nil;
     op:=#0 ;
     valeur:=0;
end ;

destructor noeud.destroy ;   //rcursive !!!
begin
     if FilsGauche<>nil then FilsGauche.destroy ;
     if FilsDroit<>nil then FilsDroit.destroy ;
     inherited destroy ;
end ;

constructor arbre.create ;
begin
     tete:=noeud.create ;
end ;

destructor arbre.destroy ;
begin
     tete.destroy ;
     inherited destroy ;
end ;

procedure arbre.Remplit(courant:noeud; s:string; signe1,signe2:char) ;    //rcursive !!!
var g1,d1  : string;
    sig1   : char ;

    function nb_elems(s : string ;var g,d : string ;s1,s2 : char ;var sig : char) : integer ;
    var trouve : boolean ;
        p,nb   :integer;
    begin        // on extrait la partie gauche et droite , spares par s1 ou s2
    p:=length(s)+1 ;nb:=0 ; // en faisant attention aux parenthses , s'il y en a
    repeat
       dec(p) ;
       if s[p]='(' then dec(nb) ;
       if s[p]=')' then inc(nb) ;
       trouve:=(nb=0) and ((s[p]=s1) or (s[p]=s2)) ;
    until (p=1) or (trouve) ;
    if p>1 then  // deux ou plusieurs elements ; mais dans un arbre binaire il y en a 2
       begin
       d:=copy(s,p+1,length(s)) ;
       g:=copy(s,1,p-1) ;
       sig:=s[p] ;
       nb_elems:=2 ;
       end
    else    // un seul lment
       begin
       d:=s ;
       g:='' ;
       sig:=#0 ;
       nb_elems:=1 ;
       end ;
    end ;

    procedure traiter_sans_parentheses(courant : noeud ;s : string ;signe1,signe2 : char) ;
    var g2,d2 : string ;
        sig2 : char ;
    begin
    if nb_elems(s,g2,d2,signe1,signe2,sig2)=2 then  // deux termes ou plus
       begin
       courant.FilsDroit:=noeud.create;
       traiter_sans_parentheses(courant.FilsDroit,d2,'*','/') ;
       courant.op:=sig2 ;
       courant.FilsGauche:=noeud.create;
       traiter_sans_parentheses(courant.FilsDroit,g2,signe1,signe2) ;
       end
    else
       if nb_elems(s,g2,d2,'*','/',sig2)=2 then
          traiter_sans_parentheses(courant,s,'*','/')
       else
          begin
          courant.op:='c'; // c pour "chiffre"
          courant.valeur:=strToInt(s) ;
          end ;
    end ;

begin
     if nb_elems(s,g1,d1,signe1,signe2,sig1)=2 then  // deux termes ou plus
        begin
        courant.FilsDroit:=noeud.create;
        remplit(courant.FilsDroit,d1,'*','/') ;
        courant.op:=sig1 ;
        courant.FilsGauche:=noeud.create;
        remplit(courant.FilsGauche,g1,signe1,signe2) ;
        end
     else  // un seul terme
        if nb_elems(s,g1,d1,'*','/',sig1)=2 then  // un terme pour l'addition mais
           remplit(courant,s,'*','/')    // plusieurs pour la multiplication : 2*3*(-5)
        else
           if d1[1]='(' then   // ou bien une seule parenthse , ex : (2+3)
              begin
              courant.op:='(' ;
              courant.FilsDroit:=noeud.create ;
              d1:=copy(d1,2,length(d1)-2) ;  // on supprime les parenthses
              Remplit(courant.FilsDroit,d1,'+','-')
              end
           else              // ou bien un seul nombre
              traiter_sans_parentheses(courant,d1,'+','-') ;
end;

function arbre.evalue(n:noeud):integer;    //rcursive, videmment
begin
     if n=nil then evalue:=0 else
     if n.op='c' then // c'est une feuille "chiffre"
        evalue:=n.valeur
     else begin       // noeud oprateur
          case n.op of
               '(': evalue:=evalue(n.FilsDroit);
               '+': evalue:=evalue(n.FilsGauche)+evalue(n.FilsDroit);
               '-': evalue:=evalue(n.FilsGauche)-evalue(n.FilsDroit);
               '*': evalue:=evalue(n.FilsGauche)*evalue(n.FilsDroit);
               '/': evalue:=evalue(n.FilsGauche) div evalue(n.FilsDroit);
          end;
     end;
end;

//---- dessin d'un arbre correspondant  une expression mathmatique ---

function arbre.compter_terminaux(courant : noeud) : integer ;   //rcursive !!!
var total : integer ;
begin
total:=0 ;
if courant.FilsGauche<>nil then inc(total,compter_terminaux(courant.FilsGauche)) ;
if courant.FilsDroit<>nil then inc(total,compter_terminaux(courant.FilsDroit)) ;
if total=0 then inc(total) ;
compter_terminaux:=total ;
end ;

function arbre.compter_niveaux(courant : noeud) : integer ;   //rcursive !!!
var rightHt : integer ;  //stocke 1 + la hauteur du fils droit
    hauteur:integer;
begin
     if courant=nil then compter_niveaux:=-1
     else begin
          hauteur:=1+compter_niveaux(courant.FilsGauche);
          rightHt:=1+compter_niveaux(courant.FilsDroit);
          if rightHt>hauteur then hauteur:=rightHt;
          compter_niveaux:=hauteur;
     end;
end ;

function Intersection(A,B:TPoint;aa,bb:real):TPoint;
var c,d,e,f,t,x,y:real;
begin
     if (A.x<>B.x) or (A.y<>B.y) then begin
        c:=longint(B.x)-longint(A.x);
        d:=longint(B.y)-longint(A.y);
        e:=longint(A.x);
        f:=longint(A.y);
        t:=sqrt(1/(sqr(c/aa)+sqr(d/bb)));
        x:=e+c*t;
        y:=f+d*t;
        result:=Point(round(x),round(y));
     end
     else result:=A;
end;

procedure arbre.dessine(courant : noeud ;limg,niveau,old_x,old_y : integer; cnv:TCanvas;
offx,offy,largeur,hauteur:integer; coeffx,coeffy:real) ;
var x,y,xx,yy,nb,ecart,hniv,rayon : integer ; s:string;  P:TPoint;
begin
rayon:=10;
nb:=compter_terminaux(courant) ;
ecart:=largeur div compter_terminaux(tete);
hniv:=hauteur div (compter_niveaux(tete)+1);
x:=offx+limg+(ecart*nb) div 2;
y:=offy+niveau*hniv;
with cnv do
      begin
      TextOut(round(12*coeffy),Hauteur+round(10*coeffy),Form1.Edit1.Text+'='+Form1.Label1.Caption);
      ellipse(x-round(rayon*coeffx),y-round(rayon*coeffy),x+round(rayon*coeffx),y+round(rayon*coeffy));
      if courant.op<>'c' then s:=courant.op
      else s:=IntToStr(courant.valeur);
      if s='*' then s:='';
      textout(x-TextWidth(s)div 2,y-TextHeight(s)div 2,s);
      if courant<>tete then
         begin
         P:=Intersection(Point(x,y),Point(old_x,old_y),round(rayon*coeffx),round(rayon*coeffy));
         xx:=P.x;
         yy:=P.y;
         moveto(xx,yy);
         P:=Intersection(Point(old_x,old_y),Point(x,y),round(rayon*coeffx),round(rayon*coeffy));
         xx:=P.x;
         yy:=P.y;
         lineto(xx,yy) ;
         end;
      end ;
if courant.FilsGauche<>nil then
   begin
   nb:=compter_terminaux(courant.FilsGauche) ;
   dessine(courant.FilsGauche,limg,niveau+1,x,y,cnv,offx,offy,largeur,hauteur,coeffx,coeffy) ;
   limg:=limg+nb*ecart;
   end ;
if courant.FilsDroit<>nil then
   begin
   nb:=compter_terminaux(courant.FilsDroit) ;
   dessine(courant.FilsDroit,limg,niveau+1,x,y,cnv,offx,offy,largeur,hauteur,coeffx,coeffy) ;
   limg:=limg+nb*ecart;
   end ;
end ;


//=============================================================================
// AUTOMATE valuant si une expression donne est correcte ou non
function Automate(s:string):string;

//le tableau qui reprsente l'automate
const etats = 5 ;
      caracs = 16 ;   // 16 caractres autoriss pour la saisie
      st = '0123456789+-*/()' ;  // les 16 caractres
      tab : array[1..etats,1..caracs] of integer =
          //0 1 2 3 4 5 6 7 8 9 + - * / ( )
          ((3,3,3,3,3,3,3,3,3,3,2,2,0,0,1,0),  {etat 1}
           (3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,0),  {etat 2}
           (3,3,3,3,3,3,3,3,3,3,5,5,5,5,0,4),  {etat 3}
           (0,0,0,0,0,0,0,0,0,0,5,5,5,5,0,4),  {etat 4}
           (3,3,3,3,3,3,3,3,3,3,0,0,0,0,1,0)); {etat 5}

var p,n:integer; car:char; etat,equilibre:integer;
begin
     if s='' then
        begin
        result:='Chane vide';
        exit;
        end;

     equilibre:=0; //comptage des parenthses
     p:=0; //position courante dans la chane s
     etat:=1;

     repeat
           inc(p);
           car:=s[p];  //caractre en cours
           if car='(' then inc(equilibre);
           if car=')' then dec(equilibre);
           if equilibre>=0 then
              begin
              n:=pos(car,st) ;  // la position du caractre en cours dans la chane de caractres autoriss
              if n>0 then etat:=tab[etat,n]; //c'est un caractre autoris
              end;
     until (p=length(s)) or (equilibre<0) or (n=0) or (etat=0);

     if equilibre<0 then result:='Il y a une parenthse fermante en trop  la position '+inttostr(p)
        else
        if (equilibre>0) then result:='Il y a une parenthse ouvrante en trop'
           else
           if n=0 then result:='Caractre non autoris  la position '+inttostr(p)
              else
              if etat=0 then result:='Expression incorrecte (erreur  la position '+inttostr(p)+')'
                 else
                 if (etat<>3) and (etat<>4) then result:='Expression incorrecte (etat final non terminal)'
                 else result:='Expression correcte';
end;
//=============================================================================

procedure TForm1.Button1Click(Sender: TObject);
var coeffx,coeffy:real;  s,resauto:string; ok:boolean;
begin
     UnArbre:=arbre.create;

     resauto:=Automate(Edit1.Text);
     ok:=(resauto='Expression correcte');

     if not ok then  //il y a une erreur de parenthsage
        begin
        UnArbre.Destroy;
        Image1.Picture:=nil;
        Label1.Caption:=resauto;
        exit;
        end;

     UnArbre.Remplit(UnArbre.tete,Edit1.Text,'+','-');

     Label1.Caption:=IntToStr(UnArbre.Evalue(UnArbre.tete));  //valuation du rsultat

     With Image1.canvas do   //dessin
          begin
          Pen.Color:=clWhite;
          Brush.Style:=bsSolid;
          Rectangle(0,0,Image1.Width,Image1.Height);
          Pen.Color:=clBlack;
          Font.Name:='Arial';
          Font.Size:=10;
          Brush.Style:=bsClear;
          end;
     UnArbre.dessine(UnArbre.tete,0,0,0,0,Image1.canvas,0,30,Image1.Width,Image1.Height-30,1,1) ;

     //Si on veut imprimer
     if CheckBox1.Checked then
            begin
            Screen.Cursor:=crHourGlass;
            Printer.Orientation:=poLandscape;
            coeffx:=Printer.PageWidth/Image1.Picture.Bitmap.Width;
            coeffy:=Printer.PageHeight/Image1.Picture.Bitmap.Height;
            Printer.BeginDoc;
            With Printer.canvas do
                 begin
                 Pen.Color:=clBlack;
                 Font.Name:='Arial';
                 Font.Height:=round(12*coeffx);
                 Brush.Style:=bsClear;
                 end;
            UnArbre.dessine(UnArbre.tete,0,0,0,0,Printer.canvas,0,round(30*coeffy),
                 Printer.PageWidth,Printer.PageHeight-round(30*coeffy),
                 coeffx,coeffy);
            Printer.EndDoc;
            Screen.Cursor:=crDefault;
            end;

     //Si on veut en plus un beau fichier BMP pour l'imprimeur !
     if CheckBox2.Checked then
            begin
            Screen.Cursor:=crHourGlass;
            Printer.Orientation:=poLandscape;
            Image2.Picture.Bitmap.Width:=Printer.PageWidth;    //diminuer si mmoire insuffisante
            Image2.Picture.Bitmap.Height:=Printer.PageHeight;  //diminuer si mmoire insuffisante
            coeffx:=Image2.Picture.Bitmap.Width/Image1.Picture.Bitmap.Width;
            coeffy:=Image2.Picture.Bitmap.Height/Image1.Picture.Bitmap.Height;
            With Image2.canvas do
                 begin
                 Pen.Color:=clWhite;
                 Brush.Style:=bsSolid;
                 Rectangle(0,0,Image2.Picture.Bitmap.Width,Image2.Picture.Bitmap.Height);
                 Pen.Color:=clBlack;
                 Font.Name:='Arial';
                 Font.Height:=round(12*coeffx);
                 Brush.Style:=bsClear;
                 end;
            UnArbre.dessine(UnArbre.tete,0,0,0,0,Image2.canvas,0,round(30*coeffy),
                 Image2.Picture.Bitmap.Width,Image2.Picture.Bitmap.Height-round(30*coeffy),
                 coeffx,coeffy);
            SaveDialog1.InitialDir:=ExtractFilePath(Application.ExeName);
            s:=ExtractFilePath(Application.ExeName)+'exemple'+IntToStr(numero)+'.bmp';
            while FileExists(s) do
                  begin
                  inc(numero);
                  s:=ExtractFilePath(Application.ExeName)+'exemple'+IntToStr(numero)+'.bmp';
                  end;
            SaveDialog1.FileName:=ExtractFileName(s);
            Screen.Cursor:=crDefault;
            if SaveDialog1.Execute then
               begin
               Screen.Cursor:=crHourGlass;
               Image2.Picture.SaveToFile(SaveDialog1.FileName);
               end;
            Image2.Picture:=nil;
            Screen.Cursor:=crDefault;
            end;

     UnArbre.Destroy;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
     Edit1.Text:='3+(5*((-2)*6*8/4-4/2*6/3/2)*7)';
     //Edit1.Text:='-1+((-1+3)*2*(1+1))';
     numero:=1;  //juste pour le nom du fichier  enregistrer
end;

procedure TForm1.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
     if key=#13 then begin
        key:=#0;  //pour empcher le "ding" !
        Button1Click(Self);
     end;
end;

end.
